import matplotlib.pyplot as plt
import numpy as np

def calculate_factorial(integer):

    product = 1
    
    for i in range(1, integer+1):
        product = product*i

    factorial = product
    
    return factorial


percent_difference = []
integers = range(20, 150)

for integer in integers:

    factorial = calculate_factorial(integer)
    log_factorial = np.log(float(factorial))

    log_stirling = integer*np.log(float(integer)) - integer

    percent_diff = (log_factorial - log_stirling)*100/log_factorial
    percent_difference.append(percent_diff)


plt.plot(integers, percent_difference)
plt.xlabel('Integer')
plt.ylabel('Percent Deviation of Stirling Approximation')
plt.show()


